implementation module Timer1

import ioTypes, clCrossCall, Timer0

InitTimers :: !(IOSystem *s (IOState *s)) !(IOadmin *s) !OS -> ( !IOadmin *s, !OS)
InitTimers [ TimerSystem timerdefs : rest ] adm os
	# (adm,os) = CreateTimers timerdefs adm os
	  os = SetIdleTimerState adm.io_timers os
	= (adm,os)
InitTimers [ other : rest ] adm os = InitTimers rest adm os
InitTimers [] adm os = ( adm, os )

CreateTimers :: ![ TimerDef *s (IOState *s) ] !(IOadmin *s) !OS -> ( !IOadmin *s, !OS )
CreateTimers [ Timer id state interval function : rest ] adm os 
   = case FindTimerWithId id adm.io_timers of
        OK t -> CreateTimers rest adm os
		Nope -> CreateTimers rest newadmin newos
				where
					millisec      =  Interval2msec interval
					(hitem,newos) = case interval of
													0 -> (0,os)
													_ -> (WinCreateTimer millisec os)
					timeradmin    =  { tid = id,
									   thandle = hitem, 
									   tinterval = millisec,
									   tlasttime = -1,
									   tfunction = function,
		 							   table = Enabled state 
									 }
					newadmin      =  { adm & io_timers = [ timeradmin : adm.io_timers ] }
CreateTimers [] adm os
	= ( adm, os ) 

/*	Opening and closing of timers. In case already a timer exists with the
	given new TimerId, the timer is not opened. Closing the timer with an
	unknown TimerId has no effect. */

OpenTimer :: !(TimerDef *s (IOState *s)) !(IOState *s) -> IOState *s
OpenTimer tdef iostate
	# (adm, os)  =  UnpackIOStateWithCheck iostate
	  (adm, os) =  CreateTimers [ tdef ] adm os
	  os = SetIdleTimerState adm.io_timers os
	= PackIOState  adm os

CloseTimer :: !TimerId !(IOState *s) -> IOState *s
CloseTimer id iostate
	= PackIOState newadm (SetIdleTimerState newadm.io_timers newos)
where
  (adm,os)       = UnpackIOStateWithCheck iostate
  (newadm,newos) = case FindTimerWithId id adm.io_timers of
					  Nope     -> (adm,os)
					  OK timer -> ( adm`, os` )
								  where adm` = { adm & io_timers = RemoveTimer adm.io_timers }
										os`  = case timer.tinterval of
													0     ->  os
													other ->  WinKillTimer timer.thandle os
  RemoveTimer []     = []
  RemoveTimer [t:ts] 
    | t.tid == id  =  ts 
	               =  [ t : RemoveTimer ts ]

/*	Enable, disable and change the TimerFunction and TimerInterval
	of the TimerDevice. The TimerInterval must at least be zero.
	Negative TimerIntervals are effectively set to zero. */

EnableTimer :: !TimerId !(IOState s) -> (IOState s)
EnableTimer id iostate = PackIOState newadm (SetIdleTimerState newadm.io_timers os)
where
  (adm, os) = UnpackIOStateWithCheck iostate
  newadm    = case FindTimerWithId id adm.io_timers of
                  Nope     -> adm
				  OK timer -> ReplaceTimer {timer & table = True} adm

DisableTimer :: !TimerId !(IOState s) -> (IOState s)
DisableTimer id iostate = PackIOState newadm (SetIdleTimerState newadm.io_timers os)
where
  (adm, os) = UnpackIOStateWithCheck iostate
  newadm    = case FindTimerWithId id adm.io_timers of
                  Nope     -> adm
				  OK timer -> ReplaceTimer {timer & table = False} adm

ChangeTimerFunction :: !TimerId !(TimerFunction *s (IOState *s)) !(IOState *s) -> IOState *s
ChangeTimerFunction id funct iostate = PackIOState newadm os
where
  (adm,os) = UnpackIOStateWithCheck iostate
  newadm   = case FindTimerWithId id adm.io_timers of
						Nope     ->  adm
						OK timer ->  ReplaceTimer {timer & tfunction = funct} adm

SetTimerInterval :: !TimerId !TimerInterval !(IOState *s) -> IOState *s
SetTimerInterval id newinterval iostate = PackIOState newadm (SetIdleTimerState newadm.io_timers newos)
where
  (adm,os)        = UnpackIOStateWithCheck iostate
  millisec        = Interval2msec newinterval
  (newadm,newos)  
    = case FindTimerWithId id adm.io_timers of
		Nope     ->  (adm,os)
		OK timer ->  ( newadm, os3)
					 where os2    = case timer.tinterval of
									  0     -> os
									  other -> WinKillTimer timer.thandle os
						   (newhandle, os3)    = case newinterval of
		 							               0     -> (0,os2)
									               other -> WinCreateTimer millisec os2
					       newadm = ReplaceTimer { timer & thandle = newhandle, tinterval = millisec } adm

SetIdleTimerState :: [ TimerAdmin s ] OS -> OS
SetIdleTimerState  [] os
	= WinSetIdleTimer False os
SetIdleTimerState [ { table,tinterval } : rest ] os
	| tinterval==0 && table
		= WinSetIdleTimer True os
		= SetIdleTimerState rest os

/*	Returns the TimerInteval that should elaps between blinks of e.g.
	a cursor. This interval can change during the interaction! */

GetTimerBlinkInterval :: !(IOState s) -> (!TimerInterval, !IOState s)
GetTimerBlinkInterval iostate = (blinktime, PackIOState adm os2)
where
  (adm, os)      =  UnpackIOStateWithCheck iostate
  (blinkms, os2) =  WinGetBlinkTime os
  blinktime      =  Millisec2interval blinkms

TicksPerSecond :== 18

::	CurrentTime
	:==	(	!Int,		// hours		(0-23)
			!Int,		// minutes		(0-59)
			!Int		// seconds		(0-59)
		);
::	CurrentDate
	:==	(	!Int,		// year
			!Int,		// month		(1-12)
			!Int,		// day			(1-31)
			!Int		// day of week	(1-7, Sunday=1, Saturday=7)
		);

/*	GetCurrentTime and GetCurrentDate return the current time and date. */

GetCurrentTime :: !(IOState s) -> (!CurrentTime, !IOState s)
GetCurrentTime iostate = ( time, PackIOState adm os`)
where
  (adm, os)    =  UnpackIOStateWithCheck iostate
  (time, os`)  =  WinGetTime os

GetCurrentDate :: !(IOState s) -> (!CurrentDate, !IOState s)
GetCurrentDate iostate = ( date, PackIOState adm os`)
where
  (adm, os)    =  UnpackIOStateWithCheck iostate
  (date, os`)  =  WinGetDate os

/*	Wait/UWait suspend the interaction for TimerInterval ticks. */

Wait :: TimerInterval x -> x
Wait interval x
  |  resultos == 99 = x
                    = x
where
  resultos = WinWait (Interval2msec interval) 99

UWait :: TimerInterval *x -> *x
UWait interval x
  |  resultos == 99 = x
                   = x
where
  resultos = WinWait (Interval2msec interval) 99

Interval2msec :: !Int -> Int
Interval2msec interval = toInt (54.925 * toReal interval)

Millisec2interval :: !Int -> Int 
Millisec2interval msec = toInt (toReal msec / 54.925)
